/*
 * Decompiled with CFR 0.152.
 */
package entities.missiles;

import core.states.GameState;
import entities.creatures.CreatureEntity;
import entities.missiles.MissileEntity;

public abstract class BoomerangMissileEntity
extends MissileEntity {
    protected boolean phase1 = true;
    protected long startTime = 0L;
    protected int phase1Time = 1000;

    public BoomerangMissileEntity(CreatureEntity parent, GameState game, String sprite, int x, int y) {
        super(parent, game, sprite, x, y);
        this.startTime = game.getTime();
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        if (!this.phase1) {
            double deltaX = (double)this.parent.getX() - this.x;
            double deltaY = (double)this.parent.getY() - this.y;
            double deltaMax = Math.max(Math.abs(deltaX), Math.abs(deltaY));
            this.dx = deltaX / deltaMax * this.moveSpeed;
            this.dy = deltaY / deltaMax * this.moveSpeed;
        }
    }

    @Override
    public void doLogic() {
        super.doLogic();
        if (this.startTime != 0L && this.phase1 && this.startTime + (long)this.phase1Time < this.game.getTime()) {
            this.phase1IsOver();
        }
    }

    protected void phase1IsOver() {
        this.phase1 = false;
    }
}

